<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DiscoveryEngine;

class GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfigAlertEnrollment extends \Google\Model
{
  /**
   * @var string
   */
  public $alertId;
  /**
   * @var string
   */
  public $enrollState;
  /**
   * @var string[]
   */
  public $notificationParams;

  /**
   * @param string
   */
  public function setAlertId($alertId)
  {
    $this->alertId = $alertId;
  }
  /**
   * @return string
   */
  public function getAlertId()
  {
    return $this->alertId;
  }
  /**
   * @param string
   */
  public function setEnrollState($enrollState)
  {
    $this->enrollState = $enrollState;
  }
  /**
   * @return string
   */
  public function getEnrollState()
  {
    return $this->enrollState;
  }
  /**
   * @param string[]
   */
  public function setNotificationParams($notificationParams)
  {
    $this->notificationParams = $notificationParams;
  }
  /**
   * @return string[]
   */
  public function getNotificationParams()
  {
    return $this->notificationParams;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfigAlertEnrollment::class, 'Google_Service_DiscoveryEngine_GoogleCloudDiscoveryengineV1alphaAlertPolicyResourceConfigAlertEnrollment');
