# Key Affixes

- [Overview](#overview)
- [Affix Values](#affix-values)
- [Affix Inclusion](#affix-inclusion)

## Overview
**Affixes** are strings attached to a generated key. They can be attached at either or both ends of the generated key. There are two affixes:
- **prefix** is attached to the beginning of the generated key.
- **suffix** is attached to the end of the generated key.

The Keygen package provides simple methods with which to specify affixes that will be attached to keys generated by a generator. The available methods are: `prefix()`, `suffix()` and `affix()`. These methods are provided by the `AbstractGenerator` class. See [AbstractGenerator Class] for a concise documentation of the affixing methods.

## Affix Values
The `prefix()` method sets the prefix string of a generator, whereas the `suffix()` method sets the suffix string of a generator. Both methods require as first argument, a value that specifies the affix string to be used. These are the possible values for the first argument:

- `null`, `true`   
    The affix string of the generator remains unchanged.

- `false`   
    Clear the current affix string of the generator and reset it to `null`.

- `string`   
    Set the string value of the `string` or `scalar` as the affix string of the generator.   

> **Getting Affixes**   

> You can get the current affix string by accessing the corresponding affix property on the generator. `$generator->prefix` gives the current prefix value, while `$generator->suffix` gives the current suffix value.

```php

```

There is a convenience `affix()` method that can be used to set either or both of the affixes at once. Its first argument is taken to be the value for the prefix string while the second argument, the value for the suffix string.

> **Chaining Affixes**   

> It is possible to define both the prefix and suffix of a generator at once by chaining the `prefix()` and `suffix()` methods. This is possible because both methods return the generator instance on which they are called, allowing for the flexibility of using [method chaining]. Hence, `$generator->affix('prefix', 'suffix')` is equivalent to `$generator->prefix('prefix')->suffix('suffix')`.

```php

```

## Affix Inclusion
When generating random keys, you may want the key length to include the length of the affixes. This is known as **affix inclusion**. This behaviour is the enabled by default in every generator. The `inclusiveAffix()` method is used to control this behaviour. It takes a `boolean` argument. If the argument is `false`, affix inclusion is **disabled**, otherwise it is **enabled**. The `$generator->inclusiveAffix` property returns a `boolean` value which indicates whether affix inclusion is enabled or not.

> **`generate()` Method**   

> When calling the `generate()` method, you can pass an optional `boolean` value as its first argument. This `boolean` value temporarily alters the affix inclusion behaviour for the key to be generated, and then reverts to the original behaviour. If this value is `true`, affix inclusion is **disabled**, otherwise it is **enabled**.


[AbstractGenerator Class]: <./abstract-generator.md>
[method chaining]: <https://en.wikipedia.org/wiki/Method_chaining>
